// Ultralight_CDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Ultralight_C.h"
#include "Ultralight_CDlg.h"

#include "umfh.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#pragma comment(lib, "umf.lib")

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUltralight_CDlg dialog

CUltralight_CDlg::CUltralight_CDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUltralight_CDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUltralight_CDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CUltralight_CDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUltralight_CDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUltralight_CDlg, CDialog)
	//{{AFX_MSG_MAP(CUltralight_CDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO_USB, OnRadioUsb)
	ON_BN_CLICKED(IDC_RADIO_COM, OnRadioCom)
	ON_BN_CLICKED(IDC_BTN_OPEN, OnBntOpen)
	ON_BN_CLICKED(IDC_BTN_AUTHEN, OnBtnAuthen)
	ON_BN_CLICKED(IDC_BTN_UPDATEKEY, OnBtnUpdatekey)
	ON_BN_CLICKED(IDC_BTN_READ, OnBtnRead)
	ON_BN_CLICKED(IDC_BTN_WRITE, OnBtnWrite)
	ON_BN_CLICKED(IDC_BTN_SETSAVE, OnBtnSetsave)
	ON_BN_CLICKED(IDC_BTN_LOCK, OnBtnLock)
	ON_BN_CLICKED(IDC_BTN_FIND, OnBtnFind)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUltralight_CDlg message handlers

BOOL CUltralight_CDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_radio_usb = (CButton*)GetDlgItem(IDC_RADIO_USB);
	m_btn_open = (CButton*)GetDlgItem(IDC_BTN_OPEN);
	m_comb_port = (CComboBox*)GetDlgItem(IDC_COMB_PORT);
	m_comb_baud = (CComboBox*)GetDlgItem(IDC_COMBO_BAUD);
	m_edit_msg  = (CEdit*)GetDlgItem(IDC_EDIT_MSG);
	m_chk_read =  (CButton*)GetDlgItem(IDC_CHECK1);



	m_radio_usb->SetCheck(1);
	m_comb_port->SetCurSel(0);
	m_comb_baud->SetCurSel(3);

	m_comb_port->EnableWindow(FALSE);
	m_comb_baud->EnableWindow(FALSE);

	SetDlgItemText(IDC_EDIT_CURKEY, "49454D4B41455242214E4143554F5946");
	SetDlgItemText(IDC_EDIT_NEWKEY, "000102030405060708090a0b0c0d0e0f");
	SetDlgItemInt(IDC_EDIT_PAGE, 4);
	

	m_hdev = -1;
	m_glMsg = "";



	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CUltralight_CDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUltralight_CDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUltralight_CDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CUltralight_CDlg::OnRadioUsb() 
{
	// TODO: Add your control notification handler code here
	m_comb_port->EnableWindow(FALSE);
	m_comb_baud->EnableWindow(FALSE);
}

void CUltralight_CDlg::OnRadioCom() 
{
	// TODO: Add your control notification handler code here
	m_comb_port->EnableWindow(TRUE);
	m_comb_baud->EnableWindow(TRUE);
}

void CUltralight_CDlg::OnBntOpen() 
{
	// TODO: Add your control notification handler code here
	if(m_hdev == -1)
	{
		if(m_radio_usb->GetCheck())
		{
			m_hdev = fw_init(100, 0);
		}
		else
		{
			int baud;
			
			baud = GetDlgItemInt(IDC_COMBO_BAUD);
			
			m_hdev = fw_init(m_comb_port->GetCurSel(), baud);
		}

		if(m_hdev != -1)
		{
			ShowMsg("Open device OK.");
			m_btn_open->SetWindowText("Close");
		}
		else
			ShowMsg("Open device error.");

	}
	else
	{
		fw_exit(m_hdev);

		m_hdev = -1;

		ShowMsg("Device closed now.");

		m_btn_open->SetWindowText("Open");
	}
}

void CUltralight_CDlg::ShowMsg(CString strmsg)
{
	int lenstr;


	m_glMsg += strmsg;

	m_glMsg += "\r\n";

	m_edit_msg->SetWindowText(m_glMsg);

	lenstr = m_glMsg.GetLength ();

	m_edit_msg->SetSel(lenstr, -1);

}

void CUltralight_CDlg::ClearMsg()
{
	m_glMsg = "";

	m_edit_msg->SetWindowText("");

}

void CUltralight_CDlg::OnBtnAuthen() 
{
	// TODO: Add your control notification handler code here
	CString strkey;
	BYTE	ucKey[17];
	int  st;

	GetDlgItemText(IDC_EDIT_CURKEY,strkey);

	if(CheckAndGetHexString(strkey, ucKey, 16))
		return ;


	st = fw_ultralt_C_authen(m_hdev,ucKey);
	if(st)
	{
		ShowMsg("Authen Key error");
	}
	else
	{
		ShowMsg("Authen Key OK");
	}


}

int CUltralight_CDlg::CheckAndGetHexString(CString str, BYTE *ucbyte, int uclen)
{
	int lenstr;
	CString strmsg;
	BYTE	szStr[4096];
	int i;


	lenstr = str.GetLength();

	if(0 == lenstr)
	{
		ShowMsg("Data must not be NULL");
		return 1;
	}

	if(lenstr != uclen*2)
	{
		strmsg.Format("Data length should be %d",2*uclen);
		ShowMsg(strmsg);
		return 2;
	}

	for(i=0; i< lenstr; i++)
		szStr[i] = (BYTE)str.GetAt(i);


	return a_hex(ucbyte, szStr, uclen);

}

void CUltralight_CDlg::OnBtnUpdatekey() 
{
	// TODO: Add your control notification handler code here
	CString strCurKey, strNewKey;
	BYTE	ucCurKey[17], ucNewKey[17];
	int  st;

	GetDlgItemText(IDC_EDIT_CURKEY,strCurKey);
	GetDlgItemText(IDC_EDIT_NEWKEY, strNewKey);

	if(CheckAndGetHexString(strCurKey, ucCurKey, 16))
		return ;

	if(CheckAndGetHexString(strNewKey, ucNewKey, 16))
		return;

	st = fw_ultralt_C_changePwd(m_hdev,ucCurKey, ucNewKey);
	if(st)
	{
		ShowMsg("Update Key error");
	}
	else
	{
		ShowMsg("Update Key OK");
	}

}

void CUltralight_CDlg::OnBtnRead() 
{
	// TODO: Add your control notification handler code here
	int page;
	BYTE	ucData[5];
	BYTE	szStr[16]={0};
	int		st;

	page = GetDlgItemInt(IDC_EDIT_PAGE);

	st = fw_read_ultralt(m_hdev, page, ucData);
	if(st)
	{
		ShowMsg("Read Error");
		return;
	}

	ShowMsg("Read OK");

	hex_a(szStr, ucData, 8);

	SetDlgItemText(IDC_EDIT_DATA, (char*)szStr);
}

void CUltralight_CDlg::OnBtnWrite() 
{
	// TODO: Add your control notification handler code here
	CString strData;
	int page;
	int	st;
	BYTE	ucData[5];

	GetDlgItemText(IDC_EDIT_DATA, strData);

	page = GetDlgItemInt(IDC_EDIT_PAGE);


	if(CheckAndGetHexString(strData, ucData, 4))
		return;

	st = fw_write_ultralt(m_hdev, page, ucData);
	if(st)
	{
		ShowMsg("Write Data Error");
	}
	else
		ShowMsg("Write Data OK.");
}	

void CUltralight_CDlg::OnBtnSetsave() 
{
	// TODO: Add your control notification handler code here

	int page;
	int	st;

	page = GetDlgItemInt(IDC_EDIT_PAGE);

	if(m_chk_read->GetCheck())
		st = fw_ultralt_C_setSafePage(m_hdev, page, 1);
	else
		st = fw_ultralt_C_setSafePage(m_hdev, page, 0);

	if(st)
	{
		ShowMsg("Set  Error");
	}
	else
		ShowMsg("Set OK.");
}

void CUltralight_CDlg::OnBtnLock() 
{
	// TODO: Add your control notification handler code here
	int page;
	int	st;

	page = GetDlgItemInt(IDC_EDIT_PAGE);

	if(page >= 16 && page <= 19)
		st = fw_ultralt_C_lockPage(m_hdev, PAGE16_19);
	else if(page >= 20 && page <= 23)
		st = fw_ultralt_C_lockPage(m_hdev, PAGE20_23);
	else if(page >= 24 && page <= 27)
		st = fw_ultralt_C_lockPage(m_hdev, PAGE24_27);
	else if(page >= 28 && page <= 31)
		st = fw_ultralt_C_lockPage(m_hdev, PAGE28_31);
	else if(page >= 32 && page <= 35)
		st = fw_ultralt_C_lockPage(m_hdev, PAGE32_35);
	else if(page >= 44 && page <= 47)
		st = fw_ultralt_C_lockPage(m_hdev, PAGE44_47);
	else
		st = fw_ultralt_C_lockPage(m_hdev, page);

	if(st)
	{
		ShowMsg("Lock page  Error");
	}
	else
		ShowMsg("Lock page OK.");
}

void CUltralight_CDlg::OnBtnFind() 
{
	// TODO: Add your control notification handler code here
	unsigned long snr, snr2;
	int	st;
	char	szCardSnr[256]={0};
	CString strmsg;

	st = fw_card(m_hdev, 1, &snr);

	if(st)
	{
		ShowMsg("Find NO Card.");
		return;
	}

	itoa(snr,(char*)szCardSnr,16);

	st = fw_anticoll2(m_hdev, 0, &snr2);
	if(st)
	{
		ShowMsg("Find Invalid Card.");
		return;
	}

	st = fw_select2(m_hdev, snr2);
	if(st)
	{
		ShowMsg("Select card error.");
		return;
	}

	itoa(snr2, (char*)&szCardSnr[4], 16);

	strmsg.Format("Find Card: %s" ,(char*)szCardSnr);

	ShowMsg(strmsg);




}
